function y = calc_SII_analytical(ene, peak_pos, Gamma, ...
    g0_mech_cav, par)

    function y = chi_opt(w)
        y = 1/(par.opt.K/2 - 1i*(w + par.opt.det));
    end

ene = ene*2*pi;
peak_pos.green = peak_pos.green*2*pi;
peak_pos.gray = peak_pos.gray*2*pi;
Gamma.green = Gamma.green*2*pi;
Gamma.gray = Gamma.gray*2*pi;

for j=1:size(ene, 2)
    
    chi_opt_p = chi_opt(ene(j));
    chi_opt_m = chi_opt(-ene(j));
    
    % All the terms
    y(j) = par.opt.Ke/2*par.mech.nb*...
        abs(par.opt.alpha*chi_opt_p - conj(par.opt.alpha)*...
        conj(chi_opt_m)).^2.*...
        (sum(Gamma.green.*g0_mech_cav.green.^2./((ene(j) ...
        - peak_pos.green).^2 + (Gamma.green./2).^2)) + ...
        sum(Gamma.gray.*g0_mech_cav.gray.^2./((ene(j) ...
        - peak_pos.gray).^2 + (Gamma.gray./2).^2)));
end

end